LIBNAME alldat '~/jim/data';

FILENAME outfile1 '~/jim/poverty/output/povall.dat';
FILENAME outfile2 '~/jim/poverty/output/pov65.dat';
FILENAME outfile3 '~/jim/poverty/output/demog_notbyftype.dat';
FILENAME outfile4 '~/jim/poverty/output/demog_ass_dist.dat';
FILENAME outfile5 '~/jim/poverty/output/medians.dat';
FILENAME outfile6 '~/jim/poverty/output/povgaps.dat';
FILENAME outfile7 '~/jim/poverty/output/demog.dat';
FILENAME outfile8 '~/jim/poverty/output/stata_se.dat';
FILENAME outfile9 '~/jim/poverty/output/demog_byftype.dat';
FILENAME outfil10 '~/jim/poverty/output/asset_byftype.dat';
FILENAME outfil11 '~/jim/poverty/output/shares.dat';
FILENAME outfil12 '~/jim/poverty/output/incpov.dat';
FILENAME outfil13 '~/jim/poverty/output/demog_inc.dat';
FILENAME outfil14 '~/jim/poverty/output/ftype_dist_by_yr.dat';
FILENAME outfil15 '~/jim/poverty/output/pov_by_dem.dat';
FILENAME outfil16 '~/jim/poverty/output/pov_by_dem2.dat';
FILENAME outfil17 '~/jim/poverty/output/demog_official.dat';
FILENAME outfil18 '~/jim/poverty/output/asset_notbyftype.dat';

DATA poverty;
   SET alldat.cons_final60_10;
RUN;


PROC SORT DATA=poverty;
   BY ref_year;
RUN;

DATA poverty;
MERGE poverty(IN=in1) alldat.prices1980(RENAME=(year=ref_year));
 BY ref_year;
 IF in1;
RUN;

PROC MEANS DATA=poverty MEDIAN; 
  VAR cons1-cons7;
  BY ref_year;
  WEIGHT wgt20;
  OUTPUT OUT=median_temp MEDIAN=med_cons1-med_cons7;
RUN;

proc univariate data=poverty;
   var cons1-cons7;
   WHERE ref_year=1980;
   weight wgt20;
   output out=thresh pctlpts=13.0 
		     pctlpre=cons1_ cons2_ cons3_ cons4_ cons5_ cons6_ cons7_
		     pctlname=p13_0;
run;

* CALCULATE THRESHOLDS FOR COMPLETE INCOME REPORTERS;
proc univariate data=poverty;
   var cons1-cons9;
   WHERE ref_year=1980 AND respstat=1 AND exclude=0;
   weight wgt20;
   output out=thresh_com pctlpts=13.0 
		     pctlpre=complete1_ complete2_ complete3_ complete4_ complete5_ 
			     complete6_ complete7_ complete8_ complete9_
		     pctlname=p13_0;
run;



DATA poverty;
   IF _N_=1 THEN SET thresh(KEEP=cons1_p13_0 cons2_p13_0 cons3_p13_0 cons4_p13_0 cons5_p13_0 cons6_p13_0 cons7_p13_0); 
   IF _N_=1 THEN SET thresh_com(KEEP=complete1_p13_0 complete2_p13_0 complete3_p13_0 complete4_p13_0 complete5_p13_0 
				     complete6_p13_0 complete7_p13_0 complete8_p13_0 complete9_p13_0); 
   SET poverty;
RUN;

DATA poverty;
   MERGE poverty median_temp;
   BY ref_year;

   ARRAY pov_cpi_(1:7);
   ARRAY pov_pce_(1:7);
   ARRAY pov_cpi150_(1:7);
   ARRAY pov_cpi_adj150_(1:7);
   ARRAY pov_cpi75_(1:7);
   ARRAY pov_pce75_(1:7);
   ARRAY pov_cpi50_(1:7);
   ARRAY pov_cpi_adj50_(1:7);
   ARRAY pov_cpi25_(1:7);
   ARRAY pov_pce25_(1:7);
   ARRAY pov_cpiu_(1:7);
   ARRAY pov_cpi_adj_(1:7);
   ARRAY med_pov_(1:7);

   ARRAY gap_cpi_(1:7);
   ARRAY gap_pce_(1:7); 
   ARRAY gap_cpi75_(1:7); 
   ARRAY gap_pce75_(1:7); 
   ARRAY gap_cpi50_(1:7);
   ARRAY gap_cpi_adj50_(1:7);
   ARRAY gap_cpi25_(1:7);
   ARRAY gap_pce25_(1:7); 
   ARRAY gap_cpiu_(1:7);
   ARRAY gap_cpi_adj_(1:7);

    ARRAY pov_gap_cpi_(1:7);
    ARRAY pov_gap_pce_(1:7);
    ARRAY pov_gap_cpi75_(1:7);
    ARRAY pov_gap_pce75_(1:7);
    ARRAY pov_gap_cpi50_(1:7);
    ARRAY pov_gap_cpi_adj50_(1:7);
    ARRAY pov_gap_cpi25_(1:7);
    ARRAY pov_gap_pce25_(1:7);
    ARRAY pov_gap_cpiu_(1:7);
    ARRAY pov_gap_cpi_adj_(1:7);

   ARRAY contemp(1:9) cons1-cons9;
   ARRAY thresh(1:7) cons1_p13_0 cons2_p13_0 cons3_p13_0 cons4_p13_0 cons5_p13_0 cons6_p13_0 cons7_p13_0;
   ARRAY med_temp(1:7) med_cons1-med_cons7;

   ARRAY com_th(1:9) complete1_p13_0 complete2_p13_0 complete3_p13_0 complete4_p13_0 complete5_p13_0
                                     complete6_p13_0 complete7_p13_0 complete8_p13_0 complete9_p13_0;
   ARRAY com_cpi_(1:9);
   ARRAY com_cpiu_(1:9);
   ARRAY com_cpi_adj_(1:9);


   DO t=1 TO 7;
    IF contemp(t) GE thresh(t)*cpi THEN pov_cpi_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpi THEN pov_cpi_(t)=1; 

    IF contemp(t) GE thresh(t)*pce THEN pov_pce_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*pce THEN pov_pce_(t)=1; 

    IF contemp(t) GE thresh(t)*cpi*1.5 THEN pov_cpi150_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpi*1.5 THEN pov_cpi150_(t)=1; 

    IF contemp(t) GE thresh(t)*cpiurs_adj*1.5 THEN pov_cpi_adj150_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpiurs_adj*1.5 THEN pov_cpi_adj150_(t)=1; 

    IF contemp(t) GE thresh(t)*cpi*0.75 THEN pov_cpi75_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpi*0.75 THEN pov_cpi75_(t)=1; 

    IF contemp(t) GE thresh(t)*pce*0.75 THEN pov_pce75_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*pce*0.75 THEN pov_pce75_(t)=1; 

    IF contemp(t) GE thresh(t)*cpi*0.50 THEN pov_cpi50_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpi*0.50 THEN pov_cpi50_(t)=1; 

    IF contemp(t) GE thresh(t)*cpiurs_adj*0.50 THEN pov_cpi_adj50_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpiurs_adj*0.50 THEN pov_cpi_adj50_(t)=1; 

    IF contemp(t) GE thresh(t)*cpi*0.25 THEN pov_cpi25_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpi*0.25 THEN pov_cpi25_(t)=1; 

    IF contemp(t) GE thresh(t)*pce*0.25 THEN pov_pce25_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*pce*0.25 THEN pov_pce25_(t)=1; 

    IF contemp(t) GE thresh(t)*cpiu THEN pov_cpiu_(t)=0;
      ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpiu THEN pov_cpiu_(t)=1; 

    IF contemp(t) GE thresh(t)*cpiurs_adj THEN pov_cpi_adj_(t)=0;
      ELSE IF contemp(t) NE . AND contemp(t) LT thresh(t)*cpiurs_adj THEN pov_cpi_adj_(t)=1; 

    IF contemp(t) GE med_temp(t)*0.5 THEN med_pov_(t)=0;
      ELSE IF contemp(t) NE . AND contemp(t) LT med_temp(t)*0.5 THEN med_pov_(t)=1; 

  end;


*************************************************
CONSUMPTION AND INCOME, COMPLETE INCOME REPORTERS
*************************************************;
   DO t=1 TO 9;
    IF contemp(t) GE com_th(t)*cpi THEN com_cpi_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT com_th(t)*cpi THEN com_cpi_(t)=1; 

    IF contemp(t) GE com_th(t)*cpiu THEN com_cpiu_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT com_th(t)*cpiu THEN com_cpiu_(t)=1; 

    IF contemp(t) GE com_th(t)*cpiurs_adj THEN com_cpi_adj_(t)=0;
    ELSE IF contemp(t) NE . AND contemp(t) LT com_th(t)*cpiurs_adj THEN com_cpi_adj_(t)=1; 
  END;

*********
GAPS
*********;
* GAPS FOR MEASURES WITHOUT HEALTH INSURANCE;
   gap_cpi_1=(max(0,(cons1_p13_0*cpi)-MAX(0,cons1)))*finlwt*4*scale; 
   gap_pce_1=(max(0,(cons1_p13_0*pce)-MAX(0,cons1)))*finlwt*4*scale; 
   gap_cpiu_1=(max(0,(cons1_p13_0*cpiu)-MAX(0,cons1)))*finlwt*4*scale;
   gap_cpi_adj_1=(max(0,(cons1_p13_0*cpiurs_adj)-MAX(0,cons1)))*finlwt*4*scale;
    
   gap_cpi75_1=(max(0,(cons1_p13_0*cpi*0.75)-MAX(0,cons1)))*finlwt*4*scale;
   gap_pce75_1=(max(0,(cons1_p13_0*pce*0.75)-MAX(0,cons1)))*finlwt*4*scale;
 
   gap_cpi50_1=(max(0,(cons1_p13_0*cpi*0.50)-MAX(0,cons1)))*finlwt*4*scale;
   gap_cpi_adj50_1=(max(0,(cons1_p13_0*cpiurs_adj*0.50)-MAX(0,cons1)))*finlwt*4*scale; 
    
   gap_cpi25_1=(max(0,(cons1_p13_0*cpi*0.25)-MAX(0,cons1)))*finlwt*4*scale; 
   gap_pce25_1=(max(0,(cons1_p13_0*pce*0.25)-MAX(0,cons1)))*finlwt*4*scale;
    
   gap_cpi_6=(max(0,(cons6_p13_0*cpi)-MAX(0,cons6)))*finlwt*4*scale; 
   gap_pce_6=(max(0,(cons6_p13_0*pce)-MAX(0,cons6)))*finlwt*4*scale;
   gap_cpiu_6=(max(0,(cons6_p13_0*cpiu)-MAX(0,cons6)))*finlwt*4*scale; 
   gap_cpi_adj_6=(max(0,(cons1_p13_0*cpiurs_adj)-MAX(0,cons6)))*finlwt*4*scale;
    
   gap_cpi75_6=(max(0,(cons6_p13_0*cpi*0.75)-MAX(0,cons6)))*finlwt*4*scale;
   gap_pce75_6=(max(0,(cons6_p13_0*pce*0.75)-MAX(0,cons6)))*finlwt*4*scale; 
    
   gap_cpi50_6=(max(0,(cons6_p13_0*cpi*0.50)-MAX(0,cons6)))*finlwt*4*scale;
   gap_cpi_adj50_6=(max(0,(cons6_p13_0*cpiurs_adj*0.50)-MAX(0,cons6)))*finlwt*4*scale;
            
   gap_cpi25_6=(max(0,(cons6_p13_0*cpi*0.25)-MAX(0,cons6)))*finlwt*4*scale;
   gap_pce25_6=(max(0,(cons6_p13_0*pce*0.25)-MAX(0,cons6)))*finlwt*4*scale;

* GAPS FOR MEASURES WITH HEALTH INSURANCE;
* ADD THE MIN(..., TO SET THE GAP AT THE VALUE OF THE THRESHOLD IF CONSUMPTION IS NEGATIVE; 
do t=2 to 5;
    
   gap_cpi_(t)=MIN(thresh(t)*cpi*scale,(max(0,((thresh(t)*cpi)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
   gap_pce_(t)=MIN(thresh(t)*pce*scale,(max(0,((thresh(t)*pce)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
   gap_cpiu_(t)=MIN(thresh(t)*cpiu*scale,
                    (max(0,((thresh(t)*cpiu)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
   gap_cpi_adj_(t)=MIN(thresh(t)*cpiurs_adj*scale,
		       (max(0,((thresh(t)*cpiurs_adj)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;

   gap_cpi75_(t)=MIN(thresh(t)*cpi*0.75*scale,
		     (max(0,((thresh(t)*cpi*0.75)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
   gap_pce75_(t)=MIN(thresh(t)*pce*0.75*scale,
		     (max(0,((thresh(t)*pce*0.75)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
    
   gap_cpi50_(t)=MIN(thresh(t)*cpi*0.50*scale,
		     (max(0,((thresh(t)*cpi*0.50)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
   gap_cpi_adj50_(t)=MIN(thresh(t)*cpiurs_adj*0.50*scale,
		         (max(0,((thresh(t)*cpiurs_adj*0.50)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
    
   gap_cpi25_(t)=MIN(thresh(t)*cpi*0.25*scale,
		     (max(0,((thresh(t)*cpi*0.25)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
   gap_pce25_(t)=MIN(thresh(t)*pce*0.25*scale,
		     (max(0,((thresh(t)*pce*0.25)-contemp(t)+pc_kink)*scale-pc_kink*fam_size)))*finlwt*4;
    
end; 
   do t=1 to 6; 
     
    pov_gap_cpi_(t)= pov_cpi_(t)*wgt20; 
    pov_gap_pce_(t)= pov_pce_(t)*wgt20; 
    pov_gap_cpi75_(t)= pov_cpi75_(t)*wgt20; 
    pov_gap_pce75_(t)= pov_pce75_(t)*wgt20; 
    pov_gap_cpi50_(t)= pov_cpi50_(t)*wgt20; 
    pov_gap_cpi_adj50_(t)= pov_cpi_adj50_(t)*wgt20; 
    pov_gap_cpi25_(t)= pov_cpi25_(t)*wgt20; 
    pov_gap_pce25_(t)= pov_pce25_(t)*wgt20; 
    pov_gap_cpiu_(t)= pov_cpiu_(t)*wgt20; 
    pov_gap_cpi_adj_(t)= pov_cpi_adj_(t)*wgt20; 
     
  end; 

*****************************************************************************
DEMOGRAPHICS
*****************************************************************************;
ARRAY fam(1:5); 

   DO t=1 TO 5; 
     IF ftype=t THEN fam(t)=1;
       ELSE fam(t)=0;
   END;

ARRAY reg(1:4); 
   DO t=1 to 4; 
        IF region=t THEN reg(t)=1;
        ELSE IF region NE . THEN reg(t)=0;
end; 
    
IF ref_year GE 1979 THEN DO;    
   IF ref_race=1 AND hispanic=0 THEN race1=1;
     ELSE race1=0; 
   IF ref_race=2 AND hispanic=0 THEN race2=1; 
     ELSE race2=0;
   race3=1-race1-race2;
END;
IF 1959 LE ref_year LE 1973 THEN DO;    
   IF ref_race=1 THEN race1=1;
     ELSE race1=0; 
   IF ref_race=2 THEN race2=1; 
     ELSE race2=0;
   race3=1-race1-race2;
END;

* FIRST, GET RID OF "GROUP" VARIALBE CREATED IN merge_all_to_master.sas;
group=.;
IF 1959 LE ref_year LE 1961 THEN group=0;
   ELSE IF 1972 LE ref_year LE 1973 THEN group=1;
   ELSE IF 1980 LE ref_year LE 1989 THEN group=2; 
   ELSE IF 1990 LE ref_year LE 1999 THEN group=3;
   ELSE IF 2000 LE ref_year LE 2010 THEN group=4; 

IF 1959 LE ref_year LE 1961 THEN DO;    
  IF cutenure=1 THEN ownhome=1;
    ELSE IF cutenure=2 THEN ownhome=0;
END;

IF ref_year GE 1971 THEN DO;    
  IF cutenure IN(1,2,3) THEN ownhome=1;
    ELSE IF cutenure IN(4,5,6) THEN ownhome=0;
END;

IF vehq GT 0 THEN have_car=1; 
   ELSE if vehq NE . THEN have_car=0;

IF ref_year GE 1972 THEN DO;
  IF incweek1 GT 0 THEN emp=1;
   ELSE IF incweek1 NE . THEN emp=0;
END;
IF 1959 LE ref_year LE 1961 THEN DO;    
  IF 0 LE earn_comp LE 5 THEN emp=1;
   ELSE emp=0;
  IF earn_comp IN(2,5,7,9) THEN emp2=1;
   ELSE emp2=0;
END;

IF 1972 LE ref_year LE 1973 THEN DO;
  IF incweek2 GT 0 THEN emp2=1;
    ELSE IF incweek2 NE . THEN emp2=0;

  IF building=1 AND ownhome=1 THEN htypedum1=1;
    ELSE htypedum1=0;
  IF building=5 AND ownhome=1 THEN htypedum2=1;
    ELSE htypedum2=0;
END;
IF ref_year GE 1979 THEN DO;
  IF incweek2 GT 0 THEN emp2=1;
    ELSE emp2=0;
  IF building=1 AND ownhome=1 THEN htypedum1=1;
    ELSE htypedum1=0;
  IF building=9 AND ownhome=1 THEN htypedum2=1;
    ELSE htypedum2=0;
END;

IF emp=1 AND emp2=1 THEN emp_type=1;
   ELSE IF emp=1 AND emp2=0 THEN emp_type=2;
   ELSE IF emp=0 AND emp2=1 THEN emp_type=3;
   ELSE IF emp=0 AND emp2=0 THEN emp_type=4;
   ELSE emp_type=0;

IF race1=1 THEN race_type=1;
   ELSE IF race2=1 THEN race_type=2;
   ELSE IF race3=1 THEN race_type=3;

*ed_type already defined for 6061;
IF 1972 LE ref_year LE 1973 THEN DO; 
        IF educ_ref IN(1,2,6) THEN ed_type=1;
           ELSE IF educ_ref=3 THEN ed_type=2; 
           ELSE IF educ_ref=4 THEN ed_type=3;
           ELSE IF educ_ref=5 THEN ed_type=4;
END; 
IF 801 LE qyear LE 955 THEN DO; 
        IF educ_ref=1 or educ_ref=2 or educ_ref=7 then ed_type=1;
           ELSE IF educ_ref=3 then ed_type=2;
           ELSE IF educ_ref=4 then ed_type=3;
           ELSE IF educ_ref=5 or educ_ref=6 then ed_type=4;
END; 
IF qyear GT 955 THEN DO;
        IF educ_ref=0 or educ_ref=10 or educ_ref=11 then ed_type=1; 
           ELSE IF educ_ref=12 then ed_type=2; 
           ELSE IF 13 LE educ_ref LE 14 then ed_type=3; 
           ELSE IF 15 LE educ_ref LE 17 THEN ed_type=4; 
END; 

ARRAY ed(1:4);
  DO t=1 TO 4;
     IF ed_type=t THEN ed(t)=1;
       ELSE ed(t)=0; 
END; 


* REGION IS MISSING FOR RURALS 1980-1995, SO CREATE REGION CODE;

IF bls_urbn=2 THEN region_code=5;
   ELSE IF bls_urbn=1 THEN region_code=region; 

dem_group2=10*ftype+ed_type; 
dem_group3=10*ftype+race_type; 
dem_group4=10*ftype+region_code;
dem_group5=100*ftype+10*ed_type+emp_type;
 

IF ref_year=1960 THEN cpi_u_rs_adj_10=4.165;
ELSE IF ref_year=1961 THEN cpi_u_rs_adj_10=4.168;
ELSE IF ref_year=1962 THEN cpi_u_rs_adj_10=4.172;
ELSE IF ref_year=1963 THEN cpi_u_rs_adj_10=4.161;
ELSE IF ref_year=1964 THEN cpi_u_rs_adj_10=4.149;
ELSE IF ref_year=1965 THEN cpi_u_rs_adj_10=4.132;
ELSE IF ref_year=1966 THEN cpi_u_rs_adj_10=4.062;
ELSE IF ref_year=1967 THEN cpi_u_rs_adj_10=3.981;
ELSE IF ref_year=1968 THEN cpi_u_rs_adj_10=3.871;
ELSE IF ref_year=1969 THEN cpi_u_rs_adj_10=3.745;
ELSE IF ref_year=1970 THEN cpi_u_rs_adj_10=3.608;
ELSE IF ref_year=1971 THEN cpi_u_rs_adj_10=3.493;
ELSE IF ref_year=1972 THEN cpi_u_rs_adj_10=3.428;
ELSE IF ref_year=1973 THEN cpi_u_rs_adj_10=3.259;
ELSE IF ref_year=1974 THEN cpi_u_rs_adj_10=2.993;
ELSE IF ref_year=1975 THEN cpi_u_rs_adj_10=2.794;
ELSE IF ref_year=1976 THEN cpi_u_rs_adj_10=2.67;
ELSE IF ref_year=1977 THEN cpi_u_rs_adj_10=2.538;
ELSE IF ref_year=1978 THEN cpi_u_rs_adj_10=2.393;
ELSE IF ref_year=1979 THEN cpi_u_rs_adj_10=2.2;
ELSE IF ref_year=1980 THEN cpi_u_rs_adj_10=1.994;
ELSE IF ref_year=1981 THEN cpi_u_rs_adj_10=1.835;
ELSE IF ref_year=1982 THEN cpi_u_rs_adj_10=1.743;
ELSE IF ref_year=1983 THEN cpi_u_rs_adj_10=1.685;
ELSE IF ref_year=1984 THEN cpi_u_rs_adj_10=1.631;
ELSE IF ref_year=1985 THEN cpi_u_rs_adj_10=1.589;
ELSE IF ref_year=1986 THEN cpi_u_rs_adj_10=1.573;
ELSE IF ref_year=1987 THEN cpi_u_rs_adj_10=1.534;
ELSE IF ref_year=1988 THEN cpi_u_rs_adj_10=1.491;
ELSE IF ref_year=1989 THEN cpi_u_rs_adj_10=1.44;
ELSE IF ref_year=1990 THEN cpi_u_rs_adj_10=1.382;
ELSE IF ref_year=1991 THEN cpi_u_rs_adj_10=1.345;
ELSE IF ref_year=1992 THEN cpi_u_rs_adj_10=1.322;
ELSE IF ref_year=1993 THEN cpi_u_rs_adj_10=1.3;
ELSE IF ref_year=1994 THEN cpi_u_rs_adj_10=1.283;
ELSE IF ref_year=1995 THEN cpi_u_rs_adj_10=1.263;
ELSE IF ref_year=1996 THEN cpi_u_rs_adj_10=1.24;
ELSE IF ref_year=1997 THEN cpi_u_rs_adj_10=1.223;
ELSE IF ref_year=1998 THEN cpi_u_rs_adj_10=1.216;
ELSE IF ref_year=1999 THEN cpi_u_rs_adj_10=1.2;
ELSE IF ref_year=2000 THEN cpi_u_rs_adj_10=1.171;
ELSE IF ref_year=2001 THEN cpi_u_rs_adj_10=1.148;
ELSE IF ref_year=2002 THEN cpi_u_rs_adj_10=1.138;
ELSE IF ref_year=2003 THEN cpi_u_rs_adj_10=1.122;
ELSE IF ref_year=2004 THEN cpi_u_rs_adj_10=1.101;
ELSE IF ref_year=2005 THEN cpi_u_rs_adj_10=1.074;
ELSE IF ref_year=2006 THEN cpi_u_rs_adj_10=1.048;
ELSE IF ref_year=2007 THEN cpi_u_rs_adj_10=1.027;
ELSE IF ref_year=2008 THEN cpi_u_rs_adj_10=0.997;
ELSE IF ref_year=2009 THEN cpi_u_rs_adj_10=1.008;
ELSE IF ref_year=2010 THEN cpi_u_rs_adj_10=1;
ELSE IF ref_year=2010 THEN cpi_u_rs_adj_10=0.98; /*NOTE: this is a place holder*/



IF ckbkactx_="A" THEN ckbkactx=0;
IF secestx_="A" THEN secestx=0;
IF usbndx_="A" THEN usbndx=0;
IF savacctx_="A" THEN savacctx=0;
 
IF comp_ndx="A" THEN compbndx=0;
IF comp_kgx="A" THEN compckgx=0;
IF comp_avx="A" THEN compsavx=0;
IF comp_ecx="A" THEN compsecx=0;
 

ARRAY ass_array ckbkactx secestx usbndx savacctx compbndx compckgx compsavx compsecx;
DO OVER ass_array;
   IF rt1 NE 5 THEN ass_array=.;
END;
 
* NOTE: DON'T USE THE MORE,SAME,LESS VARIABLES B/C WHENEVER THESE=SAME THE AMOUNT IS REPORTED;
 
tot_assets=ckbkactx+ secestx+ usbndx+ savacctx;
tot_ass_chg=compbndx+compckgx+compsavx+compsecx;
* RESTRICT CHANGE IN ASSETS TO THOSE WITH OBSERVED TOT_ASSETS;
IF tot_assets=. THEN tot_ass_chg=.;

IF 1972 LE ref_year LE 1973 THEN tot_assets=assets72;
IF 1972 LE ref_year LE 1973 THEN tot_ass_chg=chg_ass;
* DON'T HAVE LEVELS IN 1960-61, ONLY CHANGES, ALSO NEED TO PUT IN 1961 $s BEFORE CONVERTING
  TO 2005 $s SINCE REF_YEAR=1961 FOR ALL IN 60s;

IF 1959 LE ref_year LE 1961 AND yr_id=9 THEN tot_ass_chg=chg_asset*1.028;
   ELSE IF 1959 LE ref_year LE 1961 AND yr_id=0 THEN tot_ass_chg=chg_asset*1.0098;
   ELSE IF 1959 LE ref_year LE 1961 AND yr_id=1 THEN tot_ass_chg=chg_asset;

r_tot_assets=tot_assets*cpi_u_rs_adj_10;
r_tot_ass_chg=tot_ass_chg*cpi_u_rs_adj_10;
r_sav=savacctx*cpi_u_rs_adj_10;
r_sec=secestx*cpi_u_rs_adj_10;
r_usbnd=usbndx*cpi_u_rs_adj_10;
r_check=ckbkactx*cpi_u_rs_adj_10;
r_tot_debt=tot_debt2*cpi_u_rs_adj_10;   


* TO DEAL WITH SMALL OR ZERO BASE CALC PCT CHANGE AS (A2-A1)/(A2+A1);
IF r_tot_assets=0 AND r_tot_ass_chg=0 THEN pct_ass_chg=0;
   ELSE IF r_tot_assets NE . AND r_tot_ass_chg GT r_tot_assets THEN pct_ass_chg=.;
   ELSE pct_ass_chg=r_tot_ass_chg/(2*r_tot_assets-r_tot_ass_chg); 


*************
SERVICE FLOWS
*************;
r_vflow=n_tot_vflow1*cpi_u_rs_adj_10/scale*4;
r_hflow=hflow*cpi_u_rs_adj_10/scale*4;
r_dflow=r_vflow+r_hflow;

*ADJUST FOR OBS IN REF_YEAR=1959 OR 1960 THAT HAVE REF_YEAR RECODED TO 1961;
IF 1959 LE ref_year LE 1961 AND yr_id=9 THEN DO;
   r_vflow=r_vflow*1.028;
   r_hflow=r_hflow*1.028;
   r_dflow=r_dflow*1.028;
END;
IF 1959 LE ref_year LE 1961 AND yr_id=0 THEN DO;
   r_vflow=r_vflow*1.0098;
   r_hflow=r_hflow*1.0098;
   r_dflow=r_dflow*1.0098;
END;


*************
DISSAVING
*************;
save=cons9/4-cons1;
IF save LT 0 THEN dis_save=1; 
   ELSE IF save GE 0 THEN dis_save=0;

RUN;

***********************************************************************************
***********************************************************************************
***********************************************************************************
***********************************************************************************
***********************************************************************************
***********************************************************************************

***********************************************************************************
CALCULATE MEANS, MEDIANS, ETC.
***********************************************************************************;

PROC MEANS DATA=poverty; 
RUN;

*POV ALL;
PROC MEANS DATA=poverty; 
   BY ref_year;
      VAR pov1 pov2 pov3 pov_cpi_1-pov_cpi_7 pov_pce_1-pov_pce_7
	   pov_cpi150_1-pov_cpi150_7 pov_cpi_adj150_1-pov_cpi_adj150_7
	   pov_cpi75_1-pov_cpi75_7 pov_pce75_1-pov_pce75_7
	   pov_cpi50_1-pov_cpi50_7 pov_cpi_adj50_1-pov_cpi_adj50_7
	   pov_cpi25_1-pov_cpi25_7 pov_pce25_1-pov_pce25_7
	   pov_cpiu_1-pov_cpiu_7
	   pov_cpi_adj_1-pov_cpi_adj_7 med_pov_1-med_pov_7;
   WEIGHT wgt20;
   output out=povall MEAN=;
RUN;
PROC MEANS DATA=poverty; 
   BY ref_year;
   WHERE respstat=1 AND exclude=0;
      VAR official_pov com_cpi_1-com_cpi_9 
	  com_cpiu_1-com_cpiu_9 
	  com_cpi_adj_1-com_cpi_adj_9; 
   WEIGHT wgt20;
   output out=comall MEAN=;
RUN;

*GAPS ALL;
PROC MEANS SUM DATA=poverty; 
   BY ref_year; 
      VAR gap_cpi_1-gap_cpi_6 gap_pce_1-gap_pce_6
           gap_cpi75_1-gap_cpi75_6 gap_pce75_1-gap_pce75_6   
           gap_cpi50_1-gap_cpi50_6 gap_cpi_adj50_1-gap_cpi_adj50_6 
           gap_cpi25_1-gap_cpi25_6 gap_pce25_1-gap_pce25_6
           gap_cpiu_1-gap_cpiu_6 gap_cpi_adj_1-gap_cpi_adj_6
     
           pov_gap_cpi_1-pov_gap_cpi_6 pov_gap_pce_1-pov_gap_pce_6
           pov_gap_cpi75_1-pov_gap_cpi75_6 pov_gap_pce75_1-pov_gap_pce75_6      
           pov_gap_cpi50_1-pov_gap_cpi50_6 pov_gap_cpi_adj50_1-pov_gap_cpi_adj50_6 
           pov_gap_cpi25_1-pov_gap_cpi25_6 pov_gap_pce25_1-pov_gap_pce25_6
           pov_gap_cpiu_1-pov_gap_cpiu_6
	   pov_gap_cpi_adj_1-pov_gap_cpi_adj_6; 
      output out=gap_all SUM=; 
RUN;   

**********************************************
GET DISTRIBUTION OF DEMOGRAPHIC GROUPS AND EMP
**********************************************;
PROC FREQ DATA=poverty; 
   BY ref_year; 
   TABLE ftype / out=out_1;
   WEIGHT wgt20; 
RUN; 
PROC FREQ DATA=poverty; 
   BY ref_year; 
   TABLE dem_group2 / out=out_2;
   WEIGHT wgt20; 
RUN; 
PROC FREQ DATA=poverty; 
   BY ref_year; 
   TABLE dem_group3 / out=out_3;
   WEIGHT wgt20; 
RUN; 
PROC FREQ DATA=poverty; 
   BY ref_year; 
   TABLE dem_group4 / out=out_4;
   WEIGHT wgt20; 
RUN; 
PROC FREQ DATA=poverty; 
   BY ref_year; 
   TABLE dem_group5 / out=out_5;
   WEIGHT wgt20; 
RUN; 



***********************
RESULTS BY GROUP & YEAR
***********************;

PROC SORT DATA=poverty;
   BY ftype ref_year;
RUN;

* POV BY DEMOG GROUP;
PROC MEANS DATA=poverty; 
   BY ftype ref_year;
      VAR pov1 pov2 pov3 pov_cpi_1-pov_cpi_7 pov_pce_1-pov_pce_7
           pov_cpi150_1-pov_cpi150_7 pov_cpi_adj150_1-pov_cpi_adj150_7
           pov_cpi75_1-pov_cpi75_7 pov_pce75_1-pov_pce75_7
           pov_cpi50_1-pov_cpi50_7 pov_cpi_adj50_1-pov_cpi_adj50_7
           pov_cpi25_1-pov_cpi25_7 pov_pce25_1-pov_pce25_7
           pov_cpiu_1-pov_cpiu_7
	   pov_cpi_adj_1-pov_cpi_adj_7 med_pov_1-med_pov_7;
   WEIGHT wgt20; 
   output out=povdem MEAN=; 
RUN; 

* GAP BY DEMOG GROUP;
PROC MEANS SUM DATA=poverty; 
   BY ftype ref_year;
      VAR gap_cpi_1-gap_cpi_6 gap_pce_1-gap_pce_6
           gap_cpi75_1-gap_cpi75_6 gap_pce75_1-gap_pce75_6   
           gap_cpi50_1-gap_cpi50_6 gap_cpi_adj50_1-gap_cpi_adj50_6 
           gap_cpi25_1-gap_cpi25_6 gap_pce25_1-gap_pce25_6
           gap_cpiu_1-gap_cpiu_6 gap_cpi_adj_1-gap_cpi_adj_6
     
           pov_gap_cpi_1-pov_gap_cpi_6 pov_gap_pce_1-pov_gap_pce_6
           pov_gap_cpi75_1-pov_gap_cpi75_6 pov_gap_pce75_1-pov_gap_pce75_6      
           pov_gap_cpi50_1-pov_gap_cpi50_6 pov_gap_cpi_adj50_1-pov_gap_cpi_adj50_6 
           pov_gap_cpi25_1-pov_gap_cpi25_6 pov_gap_pce25_1-pov_gap_pce25_6
           pov_gap_cpiu_1-pov_gap_cpiu_6
	   pov_gap_cpi_adj_1-pov_gap_cpi_adj_6; 
      output out=gapdem SUM=; 
RUN;   


proc sort DATA=poverty;
  BY group; 
RUN;
   
proc means data=poverty MEAN MEDIAN N;
  BY group;
  WHERE ref_year NE 1982 AND ref_year NE 1983 AND group NE .; 
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms 
      emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg
      r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 no_earnr 8.4; 
  weight wgt20;
  output out=dall MEAN= N=n1 MEDIAN=med1-med33;
run;
proc means data=poverty MEAN MEDIAN N;
  BY group;    
  where pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms 
      emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg
      r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dpov MEAN= N=n1 MEDIAN=med1-med33; 
run; 
proc means SUM DATA=poverty;  
  BY group;
  WHERE ref_year NE 1982 AND ref_year NE 1983 AND group NE .;
  var wgt20 wgt21 wgt22;   
  output out=dallage SUM=;
run; 
proc means SUM DATA=poverty; 
  BY group;   
  where pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 AND group NE .; 
  var wgt20 wgt21 wgt22;   
  output out=dpovage SUM=;   
run; 

proc univariate data=poverty; 
  BY group;
  WHERE ref_year NE 1982 AND ref_year NE 1983 AND group NE .; 
   var r_tot_assets r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=dall_univ pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
		     N=n1-n3; 
run; 
proc univariate data=poverty; 
  BY group;
  WHERE pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 AND group NE .; 
   var r_tot_assets r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=dpov_univ pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ tot_debt_ tot_ass_chg_ 
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
		     N=n1-n3; 
run; 


* DEMOG OF INCOME POOR FOR COMPARISON WITH CPS;
proc means data=poverty MEAN MEDIAN N;
  BY group;    
  where com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms 
      emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg
      r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dipov MEAN= N=n1 MEDIAN=med1-med33; 
run; 
proc means SUM DATA=poverty; 
  BY group;   
  where com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
  var wgt20 wgt21 wgt22;   
  output out=dipovage SUM=;   
run; 
proc means DATA=poverty MEAN MEDIAN N; 
  BY group;   
  where official_pov=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20;
  output out=dipov_official MEAN= N=n1 MEDIAN=med1-med47;
run; 


***********************************************************************************
DEMOGRAPHICS NOT BY FTYPE
***********************************************************************************;

proc means data=poverty MEAN MEDIAN N;
  BY group;
  WHERE ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .; 
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20;
  output out=dall_all1 MEAN= N=n1 MEDIAN=med1-med47;
run;
* CONSUMPTION POOR;
proc means data=poverty MEAN MEDIAN N;
  BY group;    
  where pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dall_all2 MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* INCOME POOR;
proc means data=poverty MEAN MEDIAN N;
  BY group;    
  where com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dall_all3 MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* CONSUMPTION POOR, NOT INCOME POOR;
proc means data=poverty MEAN MEDIAN N;
  BY group;    
  where com_cpi_adj_9=0 AND pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 
	AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dall_all4 MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* INCOME POOR, NOT CONSUMPTION POOR;
proc means data=poverty MEAN MEDIAN N;
  BY group;    
  where com_cpi_adj_9=1 AND pov_cpi_adj_6=0 AND ref_year NE 1982 AND ref_year NE 1983 
	AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dall_all5 MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* INCOME AND CONSUMPTION POOR;
proc means data=poverty MEAN MEDIAN N;
  BY group;    
  where com_cpi_adj_9=1 AND pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 
	AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dall_all6 MEAN= N=n1 MEDIAN=med1-med47; 
run; 

proc univariate data=poverty; 
  BY group;
  WHERE ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .; 
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_all1 pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
		     N=n1-n4; 
run; 
proc univariate data=poverty; 
  BY group;
  where pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_all2 pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
		     N=n1-n4; 
run; 
proc univariate data=poverty; 
  BY group;
  where com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_all3 pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 
* CONSUMPTION POOR, NOT INCOME POOR;
proc univariate data=poverty; 
  BY group;
  where pov_cpi_adj_6=1 AND com_cpi_adj_9=0 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_all4 pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 
* INCOME POOR, NOT CONSUMPTION POOR;
proc univariate data=poverty; 
  BY group;
  where pov_cpi_adj_6=0 AND com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_all5 pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 
* INCOME AND CONSUMPTION POOR;
proc univariate data=poverty; 
  BY group;
  where pov_cpi_adj_6=1 AND com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_all6 pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 


***********************************************************************************
DEMOGRAPHICS BY FTYPE
***********************************************************************************;

proc sort DATA=poverty;
  BY ftype group; 
RUN;
proc means data=poverty MEAN MEDIAN N;
  BY ftype group;
  WHERE ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .; 
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20;
  output out=dall_bygrp MEAN= N=n1 MEDIAN=med1-med47;
run;
* CONSUMPTION POOR;
proc means data=poverty MEAN MEDIAN N;
  BY ftype group;    
  where pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dpov_bygrp MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* INCOME POOR;
proc means data=poverty MEAN MEDIAN N;
  BY ftype group;    
  where com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dipov_bygrp MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* CONSUMPTION POOR, NOT INCOME POOR;
proc means data=poverty MEAN MEDIAN N;
  BY ftype group;    
  where com_cpi_adj_9=0 AND pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 
	AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dcpovonly_bygrp MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* INCOME POOR, NOT CONSUMPTION POOR;
proc means data=poverty MEAN MEDIAN N;
  BY ftype group;    
  where com_cpi_adj_9=1 AND pov_cpi_adj_6=0 AND ref_year NE 1982 AND ref_year NE 1983 
	AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dipovonly_bygrp MEAN= N=n1 MEDIAN=med1-med47; 
run; 
* INCOME AND CONSUMPTION POOR;
proc means data=poverty MEAN MEDIAN N;
  BY ftype group;    
  where com_cpi_adj_9=1 AND pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 
	AND respstat=1 AND exclude=0 AND group NE .;
  var race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac 
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check
       r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
  FORMAT fam_size 8.4 perslt18 8.4 persot64 8.4 rooms 8.4 bedroom 8.4 bathrm 8.4 hlfbath 8.4 no_earnr 8.4; 
  weight wgt20; 
  output out=dicpov_bygrp MEAN= N=n1 MEDIAN=med1-med47; 
run; 

proc univariate data=poverty; 
  BY ftype group;
  WHERE ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .; 
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_ass pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
		     N=n1-n4; 
run; 
proc univariate data=poverty; 
  BY ftype group;
  where pov_cpi_adj_6=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_ass_cpov pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
		     N=n1-n4; 
run; 
proc univariate data=poverty; 
  BY ftype group;
  where com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .; 
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_ass_ipov pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 
* CONSUMPTION POOR, NOT INCOME POOR;
proc univariate data=poverty; 
  BY ftype group;
  where pov_cpi_adj_6=1 AND com_cpi_adj_9=0 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_ass_cpovonly pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 
* INCOME POOR, NOT CONSUMPTION POOR;
proc univariate data=poverty; 
  BY ftype group;
  where pov_cpi_adj_6=0 AND com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_ass_ipovonly pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 
* INCOME AND CONSUMPTION POOR;
proc univariate data=poverty; 
  BY ftype group;
  where pov_cpi_adj_6=1 AND com_cpi_adj_9=1 AND ref_year NE 1982 AND ref_year NE 1983 AND respstat=1 AND exclude=0 AND group NE .;
   var r_tot_assets pct_ass_chg r_tot_debt r_tot_ass_chg;
   weight wgt20; 
   output out=pctile_ass_cipov pctlpts=5 10 15 25 50 75 80 85 90 95
                     pctlpre=tot_ass_ pct_ass_chg_ tot_debt_ tot_ass_chg_
                     pctlname=p5 p10 p15 p25 p50 p75 p80 p85 p90 p95
                     N=n1-n4;
run; 

***********************************************************************
CREATE A SMALLER DATASET FOR CALCULATING POVERTY FOR NARROW DEMOG GROUPS
***********************************************************************;
DATA pov_dem72 pov_dem80 pov_dem10;
SET poverty(KEEP=ref_year wgt20 ftype dem_group2 dem_group3 dem_group4 dem_group5 pov_cpi_adj_6);
IF ref_year IN(1972,1980,2010);

IF ref_year=1972 THEN OUTPUT pov_dem72;
IF ref_year=1980 THEN OUTPUT pov_dem80;
IF ref_year=2010 THEN OUTPUT pov_dem10;

RUN;

*1972;

PROC SORT DATA=pov_dem72; 
   BY ftype;
RUN; 
PROC MEANS DATA=pov_dem72; 
   BY ftype;
   VAR pov_cpi_adj_6;
   WEIGHT wgt20;
   OUTPUT OUT=pd1_72 MEAN=;
RUN; 
PROC SORT DATA=pov_dem72; 
   BY dem_group2;
RUN; 
PROC MEANS DATA=pov_dem72; 
   BY dem_group2; 
   VAR pov_cpi_adj_6;
   WEIGHT wgt20;
   OUTPUT OUT=pd2_72 MEAN=;
RUN; 
PROC SORT DATA=pov_dem72; 
   BY dem_group3;
RUN; 
PROC MEANS DATA=pov_dem72; 
   BY dem_group3; 
   VAR pov_cpi_adj_6;
   WEIGHT wgt20;
   OUTPUT OUT=pd3_72 MEAN=;
RUN; 
PROC SORT DATA=pov_dem72; 
   BY dem_group4;
RUN; 
PROC MEANS DATA=pov_dem72; 
   BY dem_group4; 
   VAR pov_cpi_adj_6;
   WEIGHT wgt20;
   OUTPUT OUT=pd4_72 MEAN=;
RUN; 
PROC SORT DATA=pov_dem72; 
   BY dem_group5;
RUN; 
PROC MEANS DATA=pov_dem72; 
   BY dem_group5; 
   VAR pov_cpi_adj_6;
   WEIGHT wgt20;
   OUTPUT OUT=pd5_72 MEAN=;
RUN; 

*1980;

PROC SORT DATA=pov_dem80;
   BY ftype; 
RUN; 
PROC MEANS DATA=pov_dem80;
   BY ftype; 
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;
   OUTPUT OUT=pd1_80 MEAN=;
RUN; 
PROC SORT DATA=pov_dem80;
   BY dem_group2; 
RUN; 
PROC MEANS DATA=pov_dem80;
   BY dem_group2;         
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;
   OUTPUT OUT=pd2_80 MEAN=;
RUN; 
PROC SORT DATA=pov_dem80;
   BY dem_group3; 
RUN; 
PROC MEANS DATA=pov_dem80;
   BY dem_group3;         
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;
   OUTPUT OUT=pd3_80 MEAN=;
RUN;
PROC SORT DATA=pov_dem80;  
   BY dem_group4;
RUN; 
PROC MEANS DATA=pov_dem80;
   BY dem_group4;
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;          
   OUTPUT OUT=pd4_80 MEAN=;
RUN; 
PROC SORT DATA=pov_dem80;  
   BY dem_group5;
RUN; 
PROC MEANS DATA=pov_dem80;
   BY dem_group5;
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;          
   OUTPUT OUT=pd5_80 MEAN=;
RUN;

*2010;

PROC SORT DATA=pov_dem10;
   BY ftype; 
RUN; 
PROC MEANS DATA=pov_dem10;
   BY ftype; 
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;
   OUTPUT OUT=pd1_10 MEAN=;
RUN; 
PROC SORT DATA=pov_dem10;
   BY dem_group2; 
RUN; 
PROC MEANS DATA=pov_dem10;
   BY dem_group2;         
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;
   OUTPUT OUT=pd2_10 MEAN=;
RUN; 
PROC SORT DATA=pov_dem10;
   BY dem_group3; 
RUN; 
PROC MEANS DATA=pov_dem10;
   BY dem_group3;         
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;
   OUTPUT OUT=pd3_10 MEAN=;
RUN;
PROC SORT DATA=pov_dem10;  
   BY dem_group4;
RUN; 
PROC MEANS DATA=pov_dem10;
   BY dem_group4;
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;          
   OUTPUT OUT=pd4_10 MEAN=;
RUN; 
PROC SORT DATA=pov_dem10;  
   BY dem_group5;
RUN; 
PROC MEANS DATA=pov_dem10;
   BY dem_group5;
   VAR pov_cpi_adj_6; 
   WEIGHT wgt20;          
   OUTPUT OUT=pd5_10 MEAN=;
RUN;


PROC SORT DATA=out_1;
   BY ftype; 
RUN; 
DATA pd1;
   MERGE out_1(KEEP=ftype ref_year percent) 
	 pd1_72(KEEP=ftype pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_72)) 
	 pd1_80(KEEP=ftype pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_80)) 
	 pd1_10(KEEP=ftype pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_10));
   BY ftype;
   IF percent=. THEN percent=0;
   IF pov_72=. THEN pov_72=0;
   IF pov_80=. THEN pov_80=0;
   IF pov_10=. THEN pov_10=0;
RUN;
PROC SORT DATA=pd1;
   BY ref_year ftype; 
RUN; 

PROC MEANS DATA=pd1;
   BY ref_year;         
   VAR pov_72 pov_80 pov_10; 
   WEIGHT percent;
   OUTPUT OUT=dem1 MEAN=;
RUN;


PROC SORT DATA=out_2;
   BY dem_group2; 
RUN; 
DATA pd2;
   MERGE out_2(KEEP=dem_group2 ref_year percent) 
	 pd2_72(KEEP=dem_group2 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_72)) 
	 pd2_80(KEEP=dem_group2 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_80)) 
	 pd2_10(KEEP=dem_group2 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_10));
   BY dem_group2;
   IF percent=. THEN percent=0;
   IF pov_72=. THEN pov_72=0;
   IF pov_80=. THEN pov_80=0;
   IF pov_10=. THEN pov_10=0;
RUN;
PROC SORT DATA=pd2;
   BY ref_year dem_group2; 
RUN; 

PROC MEANS DATA=pd2;
   BY ref_year;         
   VAR pov_72 pov_80 pov_10; 
   WEIGHT percent;
   OUTPUT OUT=dem2 MEAN=;
RUN;

PROC SORT DATA=out_3;
   BY dem_group3; 
RUN; 
DATA pd3;
   MERGE out_3(KEEP=dem_group3 ref_year percent) 
	 pd3_72(KEEP=dem_group3 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_72)) 
	 pd3_80(KEEP=dem_group3 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_80)) 
	 pd3_10(KEEP=dem_group3 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_10));
   BY dem_group3;
   IF percent=. THEN percent=0;
   IF pov_72=. THEN pov_72=0;
   IF pov_80=. THEN pov_80=0;
   IF pov_10=. THEN pov_10=0;
RUN;
PROC SORT DATA=pd3;
   BY ref_year dem_group3; 
RUN; 

PROC MEANS DATA=pd3;
   BY ref_year;         
   VAR pov_72 pov_80 pov_10; 
   WEIGHT percent;
   OUTPUT OUT=dem3 MEAN=;
RUN;

PROC SORT DATA=out_4;
   BY dem_group4; 
RUN; 
DATA pd4;
   MERGE out_4(KEEP=dem_group4 ref_year percent) 
	 pd4_72(KEEP=dem_group4 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_72)) 
	 pd4_80(KEEP=dem_group4 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_80)) 
	 pd4_10(KEEP=dem_group4 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_10));
   BY dem_group4;
   IF percent=. THEN percent=0;
   IF pov_72=. THEN pov_72=0;
   IF pov_80=. THEN pov_80=0;
   IF pov_10=. THEN pov_10=0;
RUN;
PROC SORT DATA=pd4;
   BY ref_year dem_group4; 
RUN; 

PROC MEANS DATA=pd4;
   BY ref_year;         
   VAR pov_72 pov_80 pov_10; 
   WEIGHT percent;
   OUTPUT OUT=dem4 MEAN=;
RUN;

PROC SORT DATA=out_5;
   BY dem_group5; 
RUN; 
DATA pd5;
   MERGE out_5(KEEP=dem_group5 ref_year percent) 
	 pd5_72(KEEP=dem_group5 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_72)) 
	 pd5_80(KEEP=dem_group5 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_80)) 
	 pd5_10(KEEP=dem_group5 pov_cpi_adj_6 RENAME=(pov_cpi_adj_6=pov_10));
   BY dem_group5;
   IF percent=. THEN percent=0;
   IF pov_72=. THEN pov_72=0;
   IF pov_80=. THEN pov_80=0;
   IF pov_10=. THEN pov_10=0;
RUN;
PROC SORT DATA=pd5;
   BY ref_year dem_group5; 
RUN; 

PROC MEANS DATA=pd5;
   BY ref_year;         
   VAR pov_72 pov_80 pov_10; 
   WEIGHT percent;
   OUTPUT OUT=dem5 MEAN=;
RUN;










*********************************
CREATE OUTPUT FILES
*********************************;

DATA _null_;    
   SET povall; 
   FILE outfile1 lrecl=1500 pad; 
   PUT ref_year pov1 pov2 pov3 
           pov_cpi_1-pov_cpi_7 pov_pce_1-pov_pce_7 
           pov_cpi150_1-pov_cpi150_7 pov_cpi_adj150_1-pov_cpi_adj150_7
           pov_cpi75_1-pov_cpi75_7 pov_pce75_1-pov_pce75_7
           pov_cpi50_1-pov_cpi50_7 pov_cpi_adj50_1-pov_cpi_adj50_7
           pov_cpi25_1-pov_cpi25_7 pov_pce25_1-pov_pce25_7
           pov_cpiu_1-pov_cpiu_7
	   pov_cpi_adj_1-pov_cpi_adj_7 med_pov_1-med_pov_7;
RUN; 






*ENDSAS;









DATA _null_;
   SET povdem;
   FILE outfile2 lrecl=1500 pad;
   PUT ref_year ftype pov1 pov2 pov3
           pov_cpi_1-pov_cpi_7 pov_pce_1-pov_pce_7
           pov_cpi150_1-pov_cpi150_7 pov_cpi_adj150_1-pov_cpi_adj150_7
           pov_cpi75_1-pov_cpi75_7 pov_pce75_1-pov_pce75_7
           pov_cpi50_1-pov_cpi50_7 pov_cpi_adj50_1-pov_cpi_adj50_7
           pov_cpi25_1-pov_cpi25_7 pov_pce25_1-pov_pce25_7
           pov_cpiu_1-pov_cpiu_7
	   pov_cpi_adj_1-pov_cpi_adj_7 med_pov_1-med_pov_7;
RUN; 

DATA _null_; 
   SET median_temp; 
   FILE outfile5 lrecl=500 pad; 
   PUT ref_year med_cons1-med_cons7;
RUN; 

 
DATA _null_;
   SET gap_all gapdem; 
   FILE outfile6 lrecl=2000 pad;
   PUT ref_year ftype gap_cpi_1-gap_cpi_6 gap_pce_1-gap_pce_6
           gap_cpi75_1-gap_cpi75_6 gap_pce75_1-gap_pce75_6
           gap_cpi50_1-gap_cpi50_6 gap_cpi_adj50_1-gap_cpi_adj50_6
           gap_cpi25_1-gap_cpi25_6 gap_pce25_1-gap_pce25_6
           gap_cpiu_1-gap_cpiu_6 gap_cpi_adj_1-gap_cpi_adj_6 /   
    
       ref_year ftype pov_gap_cpi_1-pov_gap_cpi_6 pov_gap_pce_1-pov_gap_pce_6
           pov_gap_cpi75_1-pov_gap_cpi75_6 pov_gap_pce75_1-pov_gap_pce75_6
           pov_gap_cpi50_1-pov_gap_cpi50_6 pov_gap_cpi_adj50_1-pov_gap_cpi_adj50_6
           pov_gap_cpi25_1-pov_gap_cpi25_6 pov_gap_pce25_1-pov_gap_pce25_6
           pov_gap_cpiu_1-pov_gap_cpiu_6 
           pov_gap_cpi_adj_1-pov_gap_cpi_adj_6;
RUN; 

DATA _null_; 
   SET dall dpov dallage dpovage;
   FILE outfile7 lrecl=1500 pad;
   PUT race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4 
      have_car fam_size perslt18 persot64 rooms 
      emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg
      r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 med25
      n1 wgt20 wgt21 wgt22 r_tot_debt;
RUN; 
DATA _null_; 
   SET dall dipov dallage dipovage;
   FILE outfil13 lrecl=1500 pad;
   PUT race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4 
      have_car fam_size perslt18 persot64 rooms 
      emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg
      r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 med25
      n1 wgt20 wgt21 wgt22 r_tot_debt;
RUN; 
DATA _null_; 
   SET dall_univ dpov_univ;
   FILE outfile4 lrecl=1500 pad;
   PUT group tot_ass_p25 tot_ass_p15 tot_ass_p75 
       tot_ass_p80 tot_ass_p85 tot_ass_p90 tot_ass_p95
       tot_debt_p25 tot_debt_p50 tot_debt_p15 tot_debt_p75
       tot_debt_p80 tot_debt_p85 tot_debt_p90 tot_debt_p95
       tot_ass_chg_p25 tot_ass_chg_p15 tot_ass_chg_p75
       tot_ass_chg_p80 tot_ass_chg_p85 tot_ass_chg_p5 tot_ass_chg_p10 n1-n3;
RUN; 

DATA _null_; 
   SET dall_bygrp dpov_bygrp dipov_bygrp dcpovonly_bygrp dipovonly_bygrp dicpov_bygrp;
   FILE outfile9 lrecl=2000;
   PUT ftype group race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check 
       med42-med47 r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt n1;
RUN; 
DATA _null_; 
   SET dall_all1 dall_all2 dall_all3 dall_all4 dall_all5 dall_all6;
   FILE outfile3 lrecl=2000;
   PUT group race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check 
       med42-med47 r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt n1;
RUN; 

DATA _null_; 
   SET dipov_official;
   FILE outfil17 lrecl=2000;
   PUT group race1-race3 reg1-reg4 fam1-fam5 ownhome ed1-ed4
      have_car fam_size perslt18 persot64 rooms stove microw frig freezer disposal dishw win_ac cen_ac
       washer dryer tv computer stereo vcr bedroom bathrm hlfbath emp no_earnr r_tot_assets pct_ass_chg r_tot_ass_chg 
       r_sav r_usbnd r_check 
       med42-med47 r_vflow r_hflow r_dflow dis_save htypedum1 htypedum2 r_tot_debt;
RUN; 


DATA _null_; 
   SET pctile_ass pctile_ass_cpov pctile_ass_ipov pctile_ass_cpovonly pctile_ass_ipovonly pctile_ass_cipov;
   FILE outfil10 lrecl=500;
   PUT ftype group tot_ass_p25 tot_ass_p15 tot_ass_p75 tot_ass_p80 tot_ass_p85 tot_ass_p90 tot_ass_p95 
       pct_ass_chg_p25 pct_ass_chg_p15 pct_ass_chg_p75 pct_ass_chg_p80 pct_ass_chg_p85 pct_ass_chg_p5 pct_ass_chg_p10
       tot_debt_p25 tot_debt_p50 tot_debt_p15 tot_debt_p75
       tot_debt_p80 tot_debt_p85 tot_debt_p90 tot_debt_p95
       tot_ass_chg_p25 tot_ass_chg_p15 tot_ass_chg_p75
       tot_ass_chg_p80 tot_ass_chg_p85 tot_ass_chg_p5 tot_ass_chg_p10 n1-n4;
RUN; 

DATA _null_; 
   SET pctile_all1 pctile_all2 pctile_all3 pctile_all4 pctile_all5 pctile_all6;
   FILE outfil18 lrecl=500;
   PUT group tot_ass_p25 tot_ass_p15 tot_ass_p75 tot_ass_p80 tot_ass_p85 tot_ass_p90 tot_ass_p95 
       pct_ass_chg_p25 pct_ass_chg_p15 pct_ass_chg_p75 pct_ass_chg_p80 pct_ass_chg_p85 pct_ass_chg_p5 pct_ass_chg_p10
       tot_debt_p25 tot_debt_p50 tot_debt_p15 tot_debt_p75
       tot_debt_p80 tot_debt_p85 tot_debt_p90 tot_debt_p95
       tot_ass_chg_p25 tot_ass_chg_p15 tot_ass_chg_p75
       tot_ass_chg_p80 tot_ass_chg_p85 tot_ass_chg_p5 tot_ass_chg_p10 n1-n4;
RUN; 

DATA _null_; 
   SET poverty;
   WHERE ref_year IN(1980,1990,2000,2010);
   FILE outfile8 lrecl=300 pad;
   PUT newid ftype ref_year pov_cpi_1 pov_cpi_3 pov_cpi_6 pov_cpi_adj_1 pov_cpi_adj_3 pov_cpi_adj_6 wgt20;
RUN; 

DATA _null_;    
   SET comall; 
   FILE outfil12 lrecl=1500 pad; 
   PUT ref_year official_pov com_cpi_1-com_cpi_9
          com_cpiu_1-com_cpiu_9 
          com_cpi_adj_1-com_cpi_adj_9;
RUN; 

DATA _null_; 
   SET pd1 pd2 pd3 pd4 pd5;
   FILE outfil15 lrecl=2000;
   PUT ref_year ftype dem_group2 dem_group3 dem_group4 dem_group5 percent pov_72 pov_10;
RUN; 
DATA _null_; 
   SET dem1 dem2 dem3 dem4 dem5;
   FILE outfil16 lrecl=2000;
   PUT ref_year pov_72 pov_80 pov_10;
RUN; 


*****************************************************************************
SHARES
*****************************************************************************;
DATA temp;
   SET poverty;
* AVOID ZERO IN DENOMINATORS;
IF tflow2 GT 0 AND cons3 GT 0 AND cons6 GT 0;

fhome_rent_util=SUM(OF rendwepq rendwecq utilpq utilcq fdhomepq fdhomecq)/tflow2;
fhome_rent_util_veh_home=SUM(OF rendwepq rendwecq utilpq utilcq fdhomepq fdhomecq hflow n_tot_vflow1)/tflow2;
* also add in the rest of transportation;
fhome_rent_util_transp_home=(SUM(OF rendwepq rendwecq utilpq utilcq fdhomepq fdhomecq hflow n_tot_vflow1 transpq transcq)
                            -SUM(OF vehicpq vehiccq cartknpq cartkncq cartkupq cartkucq caropq carocq))/tflow2;
core_ratio=cons5/cons3;
core_ratio_no_hi=cons5/cons6;
 
    
KEEP cons5 cons3 cons6 core_ratio core_ratio_no_hi fhome_rent_util fhome_rent_util_veh_home fhome_rent_util_transp_home 
     ref_year wgt20 cons3_p13_0 cpi cons3 med_cons3;
RUN; 
 
proc sort DATA=temp; 
   by ref_year; 
run;

proc means DATA=temp; 
   var cons5 cons3 cons6 core_ratio core_ratio_no_hi fhome_rent_util fhome_rent_util_veh_home fhome_rent_util_transp_home;
   by ref_year;
   WEIGHT wgt20;
   output out=share1 MEAN=;
run;
proc means DATA=temp; 
   WHERE cons3_p13_0*cpi*0.5 LE cons3 LE cons3_p13_0*cpi*1.5;
   var cons5 cons3 cons6 core_ratio core_ratio_no_hi fhome_rent_util fhome_rent_util_veh_home fhome_rent_util_transp_home;
   by ref_year;
   WEIGHT wgt20;
   output out=share2 MEAN=;
run;
proc means DATA=temp; 
   WHERE cons3 LE med_cons3;
   var cons5 cons3 cons6 core_ratio core_ratio_no_hi fhome_rent_util fhome_rent_util_veh_home fhome_rent_util_transp_home;
   by ref_year;
   WEIGHT wgt20;
   output out=share3 MEAN=;
run;
DATA _null_;
   SET share1 share2 share3;
   FILE outfil11 lrecl=1500 pad;
   PUT ref_year cons5 cons3 cons6 core_ratio core_ratio_no_hi fhome_rent_util 
       fhome_rent_util_veh_home fhome_rent_util_transp_home;
RUN;       

